// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

// Procedures for conducting phi and chi tests on
// encrypted files.
//...............................................
#define	PHI_CHI_BUFFER_SIZE		(128 * 1024)
#define	TABLE_SIZE				2048

#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include <shellapi.h>
#include <shlobj.h>
#include <math.h>
#include <stdio.h>
#include "Tscmsg.h"
#define STRSAFE_LIB
#include <strsafe.h>

extern	DWORD				dwStringSafeFlag;
extern	BOOL				bIsWin9x;
extern	HINSTANCE			hInst;
extern	LPCTSTR				lpszAppName;
extern	LPCTSTR				lpEncFileIcon;
extern	LPCTSTR				lpszNullString;
extern	LPTSTR				lpszNA;
extern	LPCTSTR				lpIconPointer;
extern	BOOL				bProcessInProgress;
extern	HWND				hMainWindow;
extern	BOOL				bCancelOperation;
extern	HANDLE				hDialogModeLess;
extern	HANDLE				hDlgCurrent;
extern	BOOL				bLogo;
extern	HWND				hViewWindow;
extern	BOOL				bViewWindowDisplayed;
extern	BOOL				bScrollWnd;
extern	BOOL				bSizeWnd;
extern	DWORD				dwOldHelpNumber;
extern	int					xClient;
extern	int					yClient;
extern	int					xClientMax;
extern	int					xChar;
extern	int					yChar;
extern	int					xPos;
extern	int					yPos;
extern	int					xMax;
extern	int					yMax;
extern	int					xInc;
extern	int					yInc;
extern	int					iTotalLines;
extern	RECT				BitMapRect;
extern	SCROLLINFO			sci;
extern	PAINTSTRUCT			ps;
extern	HDC					hDC;
extern	HDC					hCompatDC;
extern	HBITMAP				hbm;
extern	TEXTMETRIC			tm;
extern	NUMBERFMT			nFormatInfo;
extern	int					RtMargin;
extern	int					iMaxWidth;
extern	SHFILEINFO			shfi1;
extern	DIARYHDR			DiaryHdr;
extern	TCHAR				szDiaryId;
extern	ULARGE_INTEGER		uliStart;
extern	ULARGE_INTEGER		uliChanges;
extern	UINT				uiWheelScrollLines;
extern	int					iDelta;
extern	CONFIG				cfg;

// A couple of local macros.
//..........................
#define Col(x) ((x + RtMargin) * xChar)
#define Line(y) (y * yChar)

// Local variables.
//.................
LPCTSTR			lpszPhiTest      = "PhiTest";
LPCTSTR			lpszPhiTitle     = "Phi Test";
LPCTSTR			lpszChiTitle	 = "Chi Test";
LPCTSTR			lpszName		 = "File Name:";
LPCTSTR			lpszName1		 = "File Name #1:";
LPCTSTR			lpszName2		 = "File Name #2:";
LPCTSTR			lpszPhiData      = "Phi Data Size:";
LPCTSTR			lpszChiData1	 = "Chi Data Size #1:";
LPCTSTR			lpszChiData2	 = "Chi Data Size #2:";
LPCTSTR			lpszExpPhi       = "Expected Phi Value (Kappa Sub r):";
LPCTSTR			lpszExpChi		 = "Expected Chi Value (Kappa Sub r):";
LPCTSTR			lpszObsPhi       = "Observed Phi Value:";
LPCTSTR			lpszObsChi		 = "Observed Chi Value:";
LPCTSTR			lpszMeanValue    = "Mean Value:";
LPCTSTR			lpszVariance     = "Variance (s):";
LPCTSTR			lpszStdDeviation = "Standard Deviation:";
LPCTSTR			lpszFreqTable	 = "Frequency Distribution Table";
LPCTSTR			lpszHeader = "Dec Hex Char        Count Percent    Dec Hex Char        Count Percent";
LPBYTE			lpPhiTable;
LPBYTE			lpTableChi1;
LPBYTE			lpTableChi2;
LPBYTE			lpPhiFileName;
HANDLE			hPhiChiEvent;
HANDLE			hPhiChiOpen;
LPBYTE			lpChiFileName1;
LPBYTE			lpChiFileName2;
ULARGE_INTEGER	uliExpectedPhi;
ULARGE_INTEGER	uliObservedPhi;
ULARGE_INTEGER	uliExpectedChi;
ULARGE_INTEGER	uliObservedChi;
ULARGE_INTEGER	liFileSize;
ULARGE_INTEGER	liChiFileSize1;
ULARGE_INTEGER	liChiFileSize2;
BOOL			bPhiTest;
DWORD			dwKappaR = 390625;
DWORD			dwKappaAdjust = 100000000;
Q_ARGUMENT		qa1;
Q_ARGUMENT		qa2;
Q_RESULT		qr1;
DWORD			dwMeanValue;
DOUBLE			fpVariance;
DOUBLE			fpStandardDeviation;
DOUBLE			fpMeanValue;
DOUBLE			fpTableEntry;
TCHAR			szPhiFile[MAX_PATH];
TCHAR			szChiFile1[MAX_PATH];
TCHAR			szChiFile2[MAX_PATH];

// Conduct a Phi test on an encrypted file.
//.........................................
VOID PhiTest(DWORD dwTypeFile)
{
	ULARGE_INTEGER	li;
	OPENFILENAME	ofn;
	HANDLE			hPhiFile = 0;
	LPBYTE			lpPhiBuffer = 0;
	DWORD			dwBytesRead;
	DWORD			dwBytesToRead;
	DWORD			dwTotalBytes;
	DWORD			dwLoop;
	DWORD			dwTableEntry;
	DWORD			dwTempESI;
	BOOL			bResult;
	RECT			rect;
	int				iCompareResult;

	bProcessInProgress = TRUE;
	bPhiTest = TRUE;

	if (dwTypeFile == RBB_FILE)
	{
		dwOldHelpNumber = ChangeHelpTopic(IDH_PHIRBB);
	}
	else if (dwTypeFile == TRUE_PAD_FILE)
	{
		dwOldHelpNumber = ChangeHelpTopic(IDH_PHI_TRUE_PAD);
	}
	else if (dwTypeFile == JOURNAL_FILE)
	{
		dwOldHelpNumber = ChangeHelpTopic(IDH_JOURNAL_PHI_TEST);
	}
	else
	{
		dwOldHelpNumber = ChangeHelpTopic(IDH_PHITEST);
	}

	if (dwTypeFile != RBB_FILE)
	{
		// Initialize the OPENFILENAME structure.
		//.......................................
		if (dwTypeFile == ENCRYPTED_FILE)
		{
			InitializeOFN(&ofn,SAVE_SOURCE);
		}
		else if (dwTypeFile == JOURNAL_FILE)
		{
			InitializeOFN(&ofn,SAVE_DIARYFILES);
		}
		else
		{
			InitializeOFN(&ofn,SAVE_TOTPFILES);
		}
		// Initialize with specific information for this procedure.
		//.........................................................
		ofn.lpstrFile = szPhiFile;
		ofn.nMaxFile = sizeof(szPhiFile);
		ofn.hwndOwner = hMainWindow;
		ofn.nFilterIndex = 1;
		ofn.Flags = (OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST |
					 OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_HIDEREADONLY |
					 OFN_SHOWHELP);
		ofn.lpstrDefExt = NULL;
		ofn.lpfnHook = MyOFNHookProc;

		if (dwTypeFile == ENCRYPTED_FILE)
		{
			ofn.lpstrFilter = TEXT("Tscg Encrypted Files [.tsc]\0*.tsc\0All Files [*.*]\0*.*\0");
			ofn.lpstrTitle = TEXT("Select an Encrypted File for a Phi Test");
		}
		else if (dwTypeFile == JOURNAL_FILE)
		{
			ofn.lpstrFilter = TEXT("Top Secret Journal Files [.jrl]\0*.jrl\0All Files [*.*]\0*.*\0");	
			ofn.lpstrTitle = TEXT("Select an Top Secret Journal File for a Phi Test");
		}
		else
		{
			ofn.lpstrFilter = TEXT("True One Time Pad Files [.pad]\0*.pad\0All Files [*.*]\0*.*\0");
			ofn.lpstrTitle = TEXT("Select a True One Time Pad File for a Phi Test");
		}
		// Setup the icon to use in the caption bar.
		//..........................................
		lpIconPointer = lpszAppName;

		while(TRUE)
		{
			// Now select an encrypted file to conduct a phi test on.
			//.......................................................
			ZeroMemory(&szPhiFile,sizeof(szPhiFile));

			if (!GetOpenFileName(&ofn))
			{
				CommDlgBoxErrorProc(IDS_GET_FILES);
				goto PhiEnd;
			}
			SaveDirName((LPBYTE)&szPhiFile,SAVE_SOURCE,TRUE);

			if (dwTypeFile == TRUE_PAD_FILE)
			{
				SaveDirName((LPBYTE)&szPhiFile,SAVE_TOTPFILES,TRUE);
			}
			else if (dwTypeFile == JOURNAL_FILE)
			{
				SaveDirName((LPBYTE)&szPhiFile,SAVE_DIARYFILES,TRUE);
			}
			// Check out the file. It has to be a valid tsc encrypted file.
			// Returns a pointer to the cke packet if valid.
			//.............................................................
			if (dwTypeFile == ENCRYPTED_FILE)
			{
				li.QuadPart = IsTscFileValid((LPBYTE)&szPhiFile);

				if (li.QuadPart == -1)
				{
					SetLastError(IDS_NOTVALIDTSCFILE);
					ErrorProcedure((LPTSTR)&szPhiFile,IDS_CREATE_OPEN,MB_OK);
					continue;
				}
			}
			else if (dwTypeFile == JOURNAL_FILE)
			{
				hPhiFile = CreateMyFile((LPTSTR)&szPhiFile,GENERIC_READ,0,NULL,
										 OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
				if (!hPhiFile)
				{
					continue;
				}
				bResult = ReadMyFile((LPTSTR)&szPhiFile,hPhiFile,&DiaryHdr,sizeof(DiaryHdr),
									  &dwBytesRead,NULL);
				if (!bResult)
				{
					goto PhiEnd;
				}
				iCompareResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&DiaryHdr,
											   sizeof(DiaryHdr),(LPCTSTR)&szDiaryId,
											   dwBytesRead);
				if (iCompareResult != CSTR_EQUAL)
				{
					// Not a valid diary file.
					//........................
					SetLastError(IDS_INVALIDDIARY);
					ErrorProcedure((LPTSTR)&szPhiFile,IDS_READ,MB_OK);
					CloseMyHandle((LPTSTR)&szPhiFile,hPhiFile);
					continue;
				}
			}
			else
			{
				// Returns with the file open and file pointer at beginning.
				//..........................................................
				hPhiFile = IsValidTruePadFile((LPTSTR)&szPhiFile);
				if (!hPhiFile)
				{
					continue;
				}
			}
			// Get a pointer to the file name.
			//................................
			lpPhiFileName = PathFindFileName((LPCTSTR)&szPhiFile);

			// Open the file and make sure it is not over the max size
			// we can handle.
			//........................................................
			if (dwTypeFile != TRUE_PAD_FILE && dwTypeFile != JOURNAL_FILE)
			{
				hPhiFile = CreateMyFile((LPTSTR)&szPhiFile,GENERIC_READ,0,
									     NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
				if (!hPhiFile)
				{
					goto PhiEnd;
				}
			}
			liFileSize.QuadPart = GetMyFileSize((LPTSTR)&szPhiFile,hPhiFile);
			if (liFileSize.QuadPart == -1)
			{
				goto PhiEnd;
			}
			if (liFileSize.QuadPart > 0xffffffff)
			{
				SetLastError(IDS_TSCTOOLARGE);
				ErrorProcedure((LPTSTR)&szPhiFile,IDS_GETFILESIZE,MB_OK);
				CloseMyHandle((LPTSTR)&szPhiFile,hPhiFile);
				hPhiFile = 0;
			}
			else
			{
				break;
			}
		}
	}
	// We have a valid tsc encrypted file, true pad file, or we are dong the rbb file. 
	// Accumulate the phi data.
	//................................................................................
	lpPhiBuffer = AllocateMemory(PHI_CHI_BUFFER_SIZE);
	lpPhiTable = AllocateMemory(TABLE_SIZE);
	if (!lpPhiBuffer || !lpPhiTable)
	{
		goto PhiEnd;
	}
	// Set up the rbb file.
	//.....................
	if (dwTypeFile == RBB_FILE)
	{
		// We are doing the rbb file. Save it to disk and set it up to process.
		//.....................................................................
		UpdateRandBitsBinFile();
		ZeroMemory(&szPhiFile,sizeof(szPhiFile));
		CopyMemory(&szPhiFile,&cfg.RandomBitsFile,MAX_PATH);

		hPhiFile = CreateMyFile((LPTSTR)&szPhiFile,GENERIC_READ,0,NULL,OPEN_EXISTING,
								 FILE_ATTRIBUTE_NORMAL,NULL);
		if (!hPhiFile)
		{
			goto PhiEnd;
		}
		liFileSize.QuadPart = (8 * 1024);
		lpPhiFileName = PathFindFileName((LPCTSTR)&szPhiFile);
		SaveDirName((LPBYTE)&szPhiFile,SAVE_SOURCE,TRUE);
	}
	bCancelOperation = FALSE;

	if (dwTypeFile == RBB_FILE)
	{
		hDialogModeLess = CreateDialog(hInst,TEXT("GETPHIDATARBB"),
									   hMainWindow,(DLGPROC)GetPhiDataProc);
	}
	else if (dwTypeFile == ENCRYPTED_FILE)
	{
		hDialogModeLess = CreateDialog(hInst,TEXT("GETPHIDATA"),
									   hMainWindow,(DLGPROC)GetPhiDataProc);
	}
	else if (dwTypeFile == JOURNAL_FILE)
	{
		hDialogModeLess = CreateDialog(hInst,TEXT("GETPHIDATAJOURNAL"),
									   hMainWindow,(DLGPROC)GetPhiDataProc);
	}
	else
	{
		hDialogModeLess = CreateDialog(hInst,TEXT("GETPHIDATATRUE"),
									   hMainWindow,(DLGPROC)GetPhiDataProc);
	}
	if (!hDialogModeLess)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto PhiEnd;
	}
	EmptyTheMessageQue();

	if (dwTypeFile == ENCRYPTED_FILE)
	{
		// Move the file pointer to the ctb byte of the cke packet.
		//.........................................................
		li.QuadPart = SetMyFilePointer((LPTSTR)&szPhiFile,hPhiFile,li.QuadPart,FILE_BEGIN);
		if (li.QuadPart == -1)
		{	
			goto PhiEnd;
		}
		// Read in the first byte which is the ctb byte.
		//..............................................
		bResult = ReadMyFile((LPTSTR)&szPhiFile,hPhiFile,lpPhiBuffer,1,&dwBytesRead,NULL);

		// If we did not read in the required number of bytes.
		//....................................................
		if (dwBytesRead != 1)
		{
			SetLastError(IDS_BYTESREADNOTEQUALTOREQUEST);
			ErrorProcedure((LPTSTR)&szPhiFile,IDS_READ,MB_OK);
			goto PhiEnd;
		}
		if (!bResult)
		{
			goto PhiEnd;
		}
		// Determine the length of the length field and read it.
		//......................................................
		__asm
		{
			mov		edx,1
			mov		edi,lpPhiBuffer
			mov		cl,byte ptr [edi]
			and		cl,LENGTH_MASK
			shl		edx,cl
			mov		dwBytesToRead,edx
		}
		bResult = ReadMyFile((LPTSTR)&szPhiFile,hPhiFile,lpPhiBuffer,
							 dwBytesToRead,&dwBytesRead,NULL);

		// If we did not read in the required number of bytes.
		//....................................................
		if (dwBytesRead != dwBytesToRead)
		{
			SetLastError(IDS_BYTESREADNOTEQUALTOREQUEST);
			ErrorProcedure((LPTSTR)&szPhiFile,IDS_READ,MB_OK);
			goto PhiEnd;
		}
		if (!bResult)
		{
			goto PhiEnd;
		}
		// Get the length of this packet.
		//...............................
		liFileSize.QuadPart = 0;
		__asm
		{
			mov		edi,lpPhiBuffer
			cmp		dwBytesToRead,1
			jne		L1
			movzx	eax,byte ptr [edi]
			mov		liFileSize.LowPart,eax
			jmp		L4
		L1:	cmp		dwBytesToRead,2
			jne		L2
			movzx	eax,word ptr [edi]
			xchg	ah,al
			mov		liFileSize.LowPart,eax
			jmp		L4
		L2:	cmp		dwBytesToRead,4
			jne		L3
			mov		eax,dword ptr [edi]
			bswap	eax
			mov		liFileSize.LowPart,eax
			jmp		L4
		L3:
		}
		CircleSwap(lpPhiBuffer,8);
		CopyMemory(&liFileSize.QuadPart,lpPhiBuffer,8);
	}
	else if (dwTypeFile == TRUE_PAD_FILE)
	{
		li.QuadPart = 4;
		li.QuadPart = SetMyFilePointer((LPTSTR)&szPhiFile,hPhiFile,li.QuadPart,FILE_BEGIN);
		if (li.QuadPart == -1)
		{
			goto PhiEnd;
		}
		// Read in the start point for the data in the file.
		//..................................................
		bResult = ReadMyFile((LPTSTR)&szPhiFile,hPhiFile,&li.QuadPart,8,&dwBytesRead,NULL);

		// If we did not read in the required number of bytes.
		//....................................................
		if (dwBytesRead != 8)
		{
			SetLastError(IDS_BYTESREADNOTEQUALTOREQUEST);
			ErrorProcedure((LPTSTR)&szPhiFile,IDS_READ,MB_OK);
			goto PhiEnd;
		}
		if (!bResult)
		{
			goto PhiEnd;
		}
		// Determine the size of the remaining data in the file.
		//......................................................
		liFileSize.QuadPart = liFileSize.QuadPart - li.QuadPart;

		// If the remaining data is less than 8K bail out.
		//................................................
		if (liFileSize.QuadPart < (8 * 1024))
		{
			SetLastError(IDS_SAMPLESIZETOOSMALL);
			ErrorProcedure((LPTSTR)&szPhiFile,IDS_READ,MB_OK);
			goto PhiEnd;
		}
		// Set the file pointer to point to the start of the data.
		//........................................................
		li.QuadPart = SetMyFilePointer((LPTSTR)&szPhiFile,hPhiFile,li.QuadPart,FILE_BEGIN);
		if (li.QuadPart == -1)
		{
			goto PhiEnd;
		}
	}
	else if (dwTypeFile == JOURNAL_FILE)
	{
		// The size of the phi data is the length of the file minus
		// the 4 byte header and the ending header.
		//.........................................................
		liFileSize.QuadPart -= (sizeof(DIARYHDR) + sizeof(DIARYEND));

		li.QuadPart = sizeof(DIARYHDR);
		li.QuadPart = SetMyFilePointer((LPTSTR)&szPhiFile,hPhiFile,li.QuadPart,FILE_BEGIN);
		if (li.QuadPart == -1)
		{
			goto PhiEnd;
		}
	}
	L4:
	li.QuadPart = 0;

	if (dwTypeFile == JOURNAL_FILE)
	{
		dwTotalBytes = liFileSize.LowPart;

		while(dwTotalBytes > 0)
		{
			EmptyTheMessageQue();
			if (bCancelOperation == TRUE)
			{
				goto PhiEnd;
			}
			if (dwTotalBytes > PHI_CHI_BUFFER_SIZE)
			{
				dwBytesToRead = PHI_CHI_BUFFER_SIZE;
				dwTotalBytes -= PHI_CHI_BUFFER_SIZE;
			}
			else
			{
				dwBytesToRead = dwTotalBytes;
				dwTotalBytes = 0;
			}
			bResult = ReadMyFile((LPTSTR)&szPhiFile,hPhiFile,lpPhiBuffer,
								  dwBytesToRead,&dwBytesRead,NULL);
			if (!bResult)
			{
				goto PhiEnd;
			}
			li.QuadPart += dwBytesRead;
			__asm
			{
				mov		edi,lpPhiTable
				mov		esi,lpPhiBuffer
				mov		ecx,dwBytesRead
			L7:	lodsb
				movzx	ebx,al
				inc		dword ptr [edi][ebx*4]
				dec		ecx
				jnz		L7
			}
		}
	}
	else
	{
		// Read in the rest of the file and accumulate stats.
		//...................................................
		while(TRUE)
		{
			EmptyTheMessageQue();
			if (bCancelOperation == TRUE)
			{
				goto PhiEnd;
			}
			bResult = ReadMyFile((LPTSTR)&szPhiFile,hPhiFile,lpPhiBuffer,
								  PHI_CHI_BUFFER_SIZE,&dwBytesRead,NULL);
			if (!bResult)
			{
				goto PhiEnd;
			}	
			// Check for eof.
			//...............
			if (dwBytesRead == 0)
			{
				break;
			}
			li.QuadPart += dwBytesRead;
			__asm
			{
				mov		edi,lpPhiTable
				mov		esi,lpPhiBuffer
				mov		ecx,dwBytesRead
			L5:	lodsb
				movzx	ebx,al
				inc		dword ptr [edi][ebx*4]
				dec		ecx
				jnz		L5
			}
		}
	}
	bResult = CloseMyHandle((LPTSTR)&szPhiFile,hPhiFile);
	if (!bResult)
	{
		goto PhiEnd;
	}
	hPhiFile = 0;

	// Make sure the data read equals the size in the header.
	//.......................................................
	if (li.QuadPart != liFileSize.QuadPart)
	{
		SetLastError(IDS_CKEHDRERROR);
		ErrorProcedure((LPTSTR)&szPhiFile,IDS_READ,MB_OK);
		goto PhiEnd;
	}
	ZeroMemory(lpPhiBuffer,PHI_CHI_BUFFER_SIZE);
	DeallocateMemory(lpPhiBuffer);
	lpPhiBuffer = 0;

	// Calculate the expected phi = phi size * (phi size - 1).
	//........................................................
	__asm
	{
		xor		edx,edx
		mov		eax,liFileSize.LowPart
		mov		ecx,eax
		dec		ecx
		mul		ecx
		mov		qa1.LOW,eax
		mov		qa1.HIGH,edx
	}
	// Multiply the result by the kappa sub r value of 
	// .00390625 * 1 x 10 to the 8th. Then adjust the result 
	//down by 1 x 10 to the 8th.
	//......................................................
	qa2.LOW = dwKappaR;
	qa2.HIGH = 0;
	QuadMultiply();
	qa1.LOW = dwKappaAdjust;
	qa1.HIGH = 0;
	QuadDivide();
	uliExpectedPhi.LowPart = qa1.LOW;
	uliExpectedPhi.HighPart = qa1.HIGH;

	// Peform the calculations for the frequency counts.
	//..................................................
	uliObservedPhi.QuadPart = 0;

	__asm
	{
		mov		ecx,256
		mov		edi,lpPhiTable
		mov		esi,0
	L6:	xor		edx,edx
		mov		eax,dword ptr [edi][esi*4]
		mov		ebx,eax
		dec		ebx
		mul		ebx
		add		uliObservedPhi.LowPart,eax
		adc		uliObservedPhi.HighPart,edx
		inc		esi
		dec		ecx
		jnz		L6
	}
	// Calculate the mean value.
	//..........................
	fpMeanValue = liFileSize.LowPart;
	fpMeanValue = fpMeanValue / 256;

	// Calculate the variance.
	//........................
	dwLoop = 256;
	dwTempESI = 0;
	fpVariance = 0;
	while(dwLoop != 0)
	{
		__asm
		{
			mov		edi,lpPhiTable
			mov		esi,dwTempESI
			mov		eax,dword ptr [edi][esi*4]
			mov		dwTableEntry,eax
		}
		fpTableEntry = dwTableEntry;
		if (fpMeanValue > fpTableEntry)
		{
			fpTableEntry = fpMeanValue - fpTableEntry;
		}
		else
		{
			fpTableEntry = fpTableEntry - fpMeanValue;
		}
		fpVariance += fpTableEntry * fpTableEntry;

		dwTempESI++;
		dwLoop--;
	}
	fpVariance = fpVariance / 255;
	fpStandardDeviation = sqrt(fpVariance);

	EmptyTheMessageQue();
	if (bCancelOperation == TRUE)
	{
		goto PhiEnd;
	}
	Sleep(1024);

	DestroyWindow(hDialogModeLess);
	bCancelOperation = FALSE;
	EmptyTheMessageQue();

	FlashMyIcon(FALSE);

	// Create our event for the view senders and recipients
	// window.
	//..................................................
	hPhiChiEvent = CreateEvent(NULL,TRUE,FALSE,TEXT("PhiChiEvent"));
	if (!hPhiChiEvent)
	{
		ErrorProcedure(TEXT("PhiChiEvent"),IDS_CREATEEVENT,MB_OK);
		goto PhiEnd;
	}
	// Create the window to display the phi data in.
	//..............................................
	GetClientRect(hMainWindow,&rect);

	// Create the window for viewing the Phi Test.
	//............................................
	hViewWindow = CreateWindowEx(WS_EX_CLIENTEDGE,lpszPhiTest,
								 lpszPhiTitle,WS_CAPTION | WS_CHILD |
								 WS_SYSMENU | WS_HSCROLL | WS_VSCROLL | 
								 WS_VISIBLE | WS_CLIPCHILDREN,rect.left,
								 rect.top+37,rect.right,rect.bottom-59,
								 hMainWindow,NULL,hInst,NULL);
	if (!hViewWindow)
	{
		ErrorProcedure(lpszNA,IDS_CREATEWINEX,MB_OK);
		goto PhiEnd;;
	}
	SetFocus(hViewWindow);

	// Open the event object.
	//.......................
	hPhiChiOpen = OpenEvent(SYNCHRONIZE,FALSE,TEXT("PhiChiEvent"));
	if (!hPhiChiOpen)
	{
		DestroyWindow(hViewWindow);
		goto PhiEnd;
	}
	// We have to wait for the Edit Event to become signaled 
	// before we can return.
	//......................................................
	while(TRUE)
	{
		if (WaitForSingleObject(hPhiChiEvent,0) == WAIT_OBJECT_0)
		{
			break;
		}
		EmptyTheMessageQue();
	}

	PhiEnd:

	FlashMyIcon(FALSE);

	if (hPhiChiOpen)
	{
		CloseHandle(hPhiChiOpen);
		hPhiChiOpen = 0;
	}
	if (hPhiChiEvent)
	{
		CloseHandle(hPhiChiEvent);
		hPhiChiEvent = 0;
	}
	if (hDialogModeLess)
	{
		DestroyWindow(hDialogModeLess);
	}
	if (hPhiFile)
	{
		CloseMyHandle((LPTSTR)&szPhiFile,hPhiFile);
	}
	if (lpPhiBuffer)
	{
		ZeroMemory(lpPhiBuffer,PHI_CHI_BUFFER_SIZE);
		DeallocateMemory(lpPhiBuffer);
	}
	if (lpPhiTable)
	{
		ZeroMemory(lpPhiTable,TABLE_SIZE);
		DeallocateMemory(lpPhiTable);
		lpPhiTable = 0;
	}
	bCancelOperation = FALSE;
	ChangeHelpTopic(dwOldHelpNumber);
	bProcessInProgress = FALSE;
}

// CALLBACK procedure for accumulating phi data.
//..............................................
LRESULT CALLBACK GetPhiDataProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			// Setup the name of the encrypted file.
			//......................................
			SetDlgItemTextFmt(hDlg,IDC_FILE1,(LPCTSTR)GetDisplayName(&shfi1,
							 (LPCTSTR)&szPhiFile));

			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDCANCEL));
			return(FALSE);
		}

		case WM_ACTIVATE:
		{
			if (wParam == 0)
			{
				hDlgCurrent = NULL;
			}
			else
			{
				hDlgCurrent = hDlg;
			}
			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				// Inform the procedure that we want to quit.
				//...........................................
				case IDCANCEL:
				{
					bCancelOperation = TRUE;
				}
				break;
			}
		}
		break;

		case WM_DESTROY:
		{
			hDialogModeLess = NULL;
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Conduct a Chi test on two encrypted files.
//...........................................
VOID ChiTest()
{
	ULARGE_INTEGER	li1;
	ULARGE_INTEGER	li2;
	OPENFILENAME	ofn;
	HANDLE			hChiFile1 = 0;
	HANDLE			hChiFile2 = 0;
	LPBYTE			lpChiBuffer = 0;
	DWORD			dwBytesRead;
	DWORD			dwBytesToRead;
	BOOL			bResult;
	RECT			rect;

	bProcessInProgress = TRUE;
	bPhiTest = FALSE;

	dwOldHelpNumber = ChangeHelpTopic(IDH_TESTCHI);

	// Initialize the OPENFILENAME structure.
	//.......................................
	InitializeOFN(&ofn,SAVE_SOURCE);

	// Initialize with specific information for this procedure.
	//.........................................................
	ofn.lpstrFile = szChiFile1;
	ofn.nMaxFile = sizeof(szChiFile1);
	ofn.hwndOwner = hMainWindow;
	ofn.lpstrFilter = TEXT("Tscg Encrypted Files [.tsc]\0*.tsc\0All Files [*.*]\0*.*\0");
	ofn.nFilterIndex = 1;
	ofn.lpstrTitle = TEXT("Select the First Encrypted File for a Chi Test");
	ofn.Flags = (OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST |
		         OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_HIDEREADONLY |
				 OFN_SHOWHELP);
	ofn.lpstrDefExt = NULL;
	ofn.lpfnHook = MyOFNHookProc;

	// Setup the icon to use in the caption bar.
	//..........................................
	lpIconPointer = lpszAppName;

	while(TRUE)
	{
		// Now select an encrypted file to conduct a chi test on.
		//.......................................................
		ZeroMemory(&szChiFile1,sizeof(szChiFile1));

		if (!GetOpenFileName(&ofn))
		{
			CommDlgBoxErrorProc(IDS_GET_FILES);
			goto ChiEnd;
		}
		SaveDirName((LPBYTE)&szChiFile1,SAVE_SOURCE,TRUE);

		// Check out the file. It has to be a valid tsc encrypted file.
		// Returns a pointer to the cke packet if valid.
		//.............................................................
		li1.QuadPart = IsTscFileValid((LPBYTE)&szChiFile1);

		if (li1.QuadPart == -1)
		{
			SetLastError(IDS_NOTVALIDTSCFILE);
			ErrorProcedure((LPTSTR)&szChiFile1,IDS_CREATE_OPEN,MB_OK);
			continue;
		}
		// Open the file and make sure it is not over the max size
		// we can handle.
		//........................................................
		lpChiFileName1 = PathFindFileName((LPCTSTR)&szChiFile1);
		hChiFile1 = CreateMyFile((LPTSTR)&szChiFile1,GENERIC_READ,0,
								  NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
		if (!hChiFile1)
		{
			goto ChiEnd;
		}
		liChiFileSize1.QuadPart = GetMyFileSize((LPTSTR)&szChiFile1,hChiFile1);
		if (liChiFileSize1.QuadPart == -1)
		{
			goto ChiEnd;
		}
		if (liChiFileSize1.QuadPart > 0xffffffff)
		{
			SetLastError(IDS_TSCTOOLARGE);
			ErrorProcedure((LPTSTR)&szChiFile1,IDS_GETFILESIZE,MB_OK);
			CloseMyHandle((LPTSTR)&szChiFile1,hChiFile1);
			hChiFile1 = 0;
		}
		else
		{
			break;
		}
	}
	EmptyTheMessageQue();

	// Get the second chi file.
	//.........................
	ofn.lpstrFile = szChiFile2;
	ofn.nMaxFile = sizeof(szChiFile2);
	ofn.lpstrTitle = TEXT("Select the Second Encrypted File for a Chi Test");

	while(TRUE)
	{
		// Now select an encrypted file to conduct a chi test on.
		//.......................................................
		ZeroMemory(&szChiFile2,sizeof(szChiFile2));

		if (!GetOpenFileName(&ofn))
		{
			CommDlgBoxErrorProc(IDS_GET_FILES);
			bProcessInProgress = FALSE;
			goto ChiEnd;
		}
		SaveDirName((LPBYTE)&szChiFile2,SAVE_SOURCE,TRUE);

		// Check out the file. It has to be a valid tsc encrypted file.
		// Returns a pointer to the cke packet if valid.
		//.............................................................
		li2.QuadPart = IsTscFileValid((LPBYTE)&szChiFile2);

		if (li2.QuadPart == -1)
		{
			SetLastError(IDS_NOTVALIDTSCFILE);
			ErrorProcedure((LPTSTR)&szChiFile2,IDS_CREATE_OPEN,MB_OK);
			continue;
		}
		// Open the file and make sure it is not over the max size
		// we can handle.
		//........................................................
		lpChiFileName2 = PathFindFileName((LPCTSTR)&szChiFile2);
		hChiFile2 = CreateMyFile((LPTSTR)&szChiFile2,GENERIC_READ,0,
								  NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
		if (!hChiFile2)
		{
			goto ChiEnd;
		}
		liChiFileSize2.QuadPart = GetMyFileSize((LPTSTR)&szChiFile2,hChiFile2);
		if (liChiFileSize2.QuadPart == -1)
		{
			goto ChiEnd;
		}
		if (liChiFileSize2.QuadPart > 0xffffffff)
		{
			SetLastError(IDS_TSCTOOLARGE);
			ErrorProcedure((LPTSTR)&szChiFile2,IDS_GETFILESIZE,MB_OK);
			CloseMyHandle((LPTSTR)&szChiFile2,hChiFile2);
			hChiFile2 = 0;
		}
		else
		{
			break;
		}
	}
	EmptyTheMessageQue();

	// We have two valid tsc encrypted files. Get the stats.
	//......................................................
	lpChiBuffer = AllocateMemory(PHI_CHI_BUFFER_SIZE);
	lpTableChi1 = AllocateMemory(TABLE_SIZE);
	lpTableChi2 = AllocateMemory(TABLE_SIZE);
	if (!lpChiBuffer || !lpTableChi1 || !lpTableChi2)
	{
		goto ChiEnd;
	}
	bCancelOperation = FALSE;
	hDialogModeLess = CreateDialog(hInst,TEXT("GETCHIDATA"),
								   hMainWindow,(DLGPROC)GetChiDataProc);

	if (!hDialogModeLess)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto ChiEnd;
	}
	EmptyTheMessageQue();
	if (bCancelOperation == TRUE)
	{
		goto ChiEnd;
	}
	// Accululate chi data on both of the files. Do the first chi file.
	//.................................................................
	li1.QuadPart = SetMyFilePointer((LPTSTR)&szChiFile1,hChiFile1,li1.QuadPart,FILE_BEGIN);
	if (li1.QuadPart == -1)
	{
		goto ChiEnd;
	}
	// Read in the first byte which is the ctb byte.
	//..............................................
	bResult = ReadMyFile((LPTSTR)&szChiFile1,hChiFile1,lpChiBuffer,1,&dwBytesRead,NULL);

	// If we did not read in the required number of bytes.
	//....................................................
	if (dwBytesRead != 1)
	{
		SetLastError(IDS_BYTESREADNOTEQUALTOREQUEST);
		ErrorProcedure((LPTSTR)&szChiFile1,IDS_READ,MB_OK);
		goto ChiEnd;
	}
	if (!bResult)
	{
		goto ChiEnd;
	}
	// Determine the length of the length field and read it.
	//......................................................
	__asm
	{
		mov		edx,1
		mov		edi,lpChiBuffer
		mov		cl,byte ptr [edi]
		and		cl,LENGTH_MASK
		shl		edx,cl
		mov		dwBytesToRead,edx
	}
	bResult = ReadMyFile((LPTSTR)&szChiFile1,hChiFile1,lpChiBuffer,
						  dwBytesToRead,&dwBytesRead,NULL);

	// If we did not read in the required number of bytes.
	//....................................................
	if (dwBytesRead != dwBytesToRead)
	{
		SetLastError(IDS_BYTESREADNOTEQUALTOREQUEST);
		ErrorProcedure((LPTSTR)&szChiFile1,IDS_READ,MB_OK);
		goto ChiEnd;
	}
	if (!bResult)
	{
		goto ChiEnd;
	}
	// Get the length of this packet.
	//...............................
	liChiFileSize1.QuadPart = 0;
	__asm
	{
		mov		edi,lpChiBuffer
		cmp		dwBytesToRead,1
		jne		L1
		movzx	eax,byte ptr [edi]
		mov		liChiFileSize1.LowPart,eax
		jmp		L4
	L1:	cmp		dwBytesToRead,2
		jne		L2
		movzx	eax,word ptr [edi]
		xchg	ah,al
		mov		liChiFileSize1.LowPart,eax
		jmp		L4
	L2:	cmp		dwBytesToRead,4
		jne		L3
		mov		eax,dword ptr [edi]
		bswap	eax
		mov		liChiFileSize1.LowPart,eax
		jmp		L4
	L3:
	}
	CircleSwap(lpChiBuffer,8);
	CopyMemory(&liChiFileSize1.QuadPart,lpChiBuffer,8);

	L4:

	li1.QuadPart = 0;
						
	// Read in the rest of the file and accumulate stats.
	//...................................................
	while(TRUE)
	{
		EmptyTheMessageQue();
		if (bCancelOperation == TRUE)
		{
			goto ChiEnd;
		}
		bResult = ReadMyFile((LPTSTR)&szChiFile1,hChiFile1,lpChiBuffer,
							  PHI_CHI_BUFFER_SIZE,&dwBytesRead,NULL);
		if (!bResult)
		{
			goto ChiEnd;
		}
		// Check for eof.
		//...............
		if (dwBytesRead == 0)
		{
			break;
		}
		li1.QuadPart += dwBytesRead;
		__asm
		{
			mov		edi,lpTableChi1
			mov		esi,lpChiBuffer
			mov		ecx,dwBytesRead
		L5:	lodsb
			movzx	ebx,al
			inc		dword ptr [edi][ebx*4]
			dec		ecx
			jnz		L5
		}
	}
	bResult = CloseMyHandle((LPTSTR)&szChiFile1,hChiFile1);
	if (!bResult)
	{
		goto ChiEnd;
	}
	hChiFile1 = 0;

	// Make sure the data read equals the size in the header.
	//.......................................................
	if (li1.QuadPart != liChiFileSize1.QuadPart)
	{
		SetLastError(IDS_CKEHDRERROR);
		ErrorProcedure((LPTSTR)&szChiFile1,IDS_READ,MB_OK);
		goto ChiEnd;
	}
	EmptyTheMessageQue();
	if (bCancelOperation == TRUE)
	{
		goto ChiEnd;
	}
	// Now accumulate chi data for the second file.
	//.............................................
	li2.QuadPart = SetMyFilePointer((LPTSTR)&szChiFile2,hChiFile2,li2.QuadPart,FILE_BEGIN);
	if (li2.QuadPart == -1)
	{
		goto ChiEnd;
	}
	// Read in the first byte which is the ctb byte.
	//..............................................
	bResult = ReadMyFile((LPTSTR)&szChiFile2,hChiFile2,lpChiBuffer,1,&dwBytesRead,NULL);

	// If we did not read in the required number of bytes.
	//....................................................
	if (dwBytesRead != 1)
	{
		SetLastError(IDS_BYTESREADNOTEQUALTOREQUEST);
		ErrorProcedure((LPTSTR)&szChiFile2,IDS_READ,MB_OK);
		goto ChiEnd;
	}
	if (!bResult)
	{
		goto ChiEnd;
	}
	// Determine the length of the length field and read it.
	//......................................................
	__asm
	{
		mov		edx,1
		mov		edi,lpChiBuffer
		mov		cl,byte ptr [edi]
		and		cl,LENGTH_MASK
		shl		edx,cl
		mov		dwBytesToRead,edx
	}
	bResult = ReadMyFile((LPTSTR)&szChiFile2,hChiFile2,lpChiBuffer,
						  dwBytesToRead,&dwBytesRead,NULL);

	// If we did not read in the required number of bytes.
	//....................................................
	if (dwBytesRead != dwBytesToRead)
	{
		SetLastError(IDS_BYTESREADNOTEQUALTOREQUEST);
		ErrorProcedure((LPTSTR)&szChiFile2,IDS_READ,MB_OK);
		goto ChiEnd;
	}
	if (!bResult)
	{
		goto ChiEnd;
	}
	// Get the length of this packet.
	//...............................
	liChiFileSize2.QuadPart = 0;
	__asm
	{
		mov		edi,lpChiBuffer
		cmp		dwBytesToRead,1
		jne		L6
		movzx	eax,byte ptr [edi]
		mov		liChiFileSize2.LowPart,eax
		jmp		L9
	L6:	cmp		dwBytesToRead,2
		jne		L7
		movzx	eax,word ptr [edi]
		xchg	ah,al
		mov		liChiFileSize2.LowPart,eax
		jmp		L9
	L7:	cmp		dwBytesToRead,4
		jne		L8
		mov		eax,dword ptr [edi]
		bswap	eax
		mov		liChiFileSize2.LowPart,eax
		jmp		L9
	L8:
	}
	CircleSwap(lpChiBuffer,8);
	CopyMemory(&liChiFileSize2.QuadPart,lpChiBuffer,8);

	L9:

	li2.QuadPart = 0;
						
	// Read in the rest of the file and accumulate stats.
	//...................................................
	while(TRUE)
	{
		EmptyTheMessageQue();
		if (bCancelOperation == TRUE)
		{
			goto ChiEnd;
		}
		bResult = ReadMyFile((LPTSTR)&szChiFile2,hChiFile2,lpChiBuffer,
							  PHI_CHI_BUFFER_SIZE,&dwBytesRead,NULL);
		if (!bResult)
		{
			goto ChiEnd;
		}
		// Check for eof.
		//...............
		if (dwBytesRead == 0)
		{
			break;
		}
		li2.QuadPart += dwBytesRead;
		__asm
		{
			mov		edi,lpTableChi2
			mov		esi,lpChiBuffer
			mov		ecx,dwBytesRead
	   L10:	lodsb
			movzx	ebx,al
			inc		dword ptr [edi][ebx*4]
			dec		ecx
			jnz		L10
		}
	}
	bResult = CloseMyHandle((LPTSTR)&szChiFile2,hChiFile2);
	if (!bResult)
	{
		goto ChiEnd;
	}
	hChiFile2 = 0;

	// Close the chi buffer, it is no longer neeeded.
	//...............................................
	if (lpChiBuffer)
	{
		ZeroMemory(lpChiBuffer,PHI_CHI_BUFFER_SIZE);
		DeallocateMemory(lpChiBuffer);
		lpChiBuffer = 0;
	}
	// Make sure the data read equals the size in the header.
	//.......................................................
	if (li2.QuadPart != liChiFileSize2.QuadPart)
	{
		SetLastError(IDS_CKEHDRERROR);
		ErrorProcedure((LPTSTR)&szChiFile2,IDS_READ,MB_OK);
		goto ChiEnd;
	}
	EmptyTheMessageQue();
	if (bCancelOperation == TRUE)
	{
		goto ChiEnd;
	}
	// Calculate the expected chi value first.
	//........................................
	__asm
	{
		xor		edx,edx
		mov		eax,liChiFileSize1.LowPart
		mov		ecx,liChiFileSize2.LowPart
		mul		ecx
		mov		qa1.LOW,eax
		mov		qa1.HIGH,edx
	}
	// Multiply the result by the kappa sub r value of 
	// .00390625 * 1 x 10 to the 8th. Then adjust the result 
	//down by 1 x 10 to the 8th.
	//......................................................
	qa2.LOW = dwKappaR;
	qa2.HIGH = 0;
	QuadMultiply();
	qa1.LOW = dwKappaAdjust;
	qa1.HIGH = 0;
	QuadDivide();
	uliExpectedChi.LowPart = qa1.LOW;
	uliExpectedChi.HighPart = qa1.HIGH;

	// Now perform the calculations for the two frequency counts.
	//...........................................................
	uliObservedChi.QuadPart = 0;

	__asm
	{
		mov		ecx,256
		mov		esi,0
   L11:	xor		edx,edx
		mov		edi,lpTableChi1
		mov		eax,dword ptr [edi][esi*4]
		mov		edi,lpTableChi2
		mov		ebx,dword ptr [edi][esi*4]
		mul		ebx
		add		uliObservedChi.LowPart,eax
		adc		uliObservedChi.HighPart,edx
		inc		esi
		dec		ecx
		jnz		L11
	}
	EmptyTheMessageQue();
	if (bCancelOperation == TRUE)
	{
		goto ChiEnd;
	}
	Sleep(1024);

	DestroyWindow(hDialogModeLess);
	bCancelOperation = FALSE;
	EmptyTheMessageQue();

	FlashMyIcon(FALSE);

	// Create our event for the view senders and recipients
	// window.
	//..................................................
	hPhiChiEvent = CreateEvent(NULL,TRUE,FALSE,TEXT("PhiChiEvent"));
	if (!hPhiChiEvent)
	{
		ErrorProcedure(TEXT("PhiChiEvent"),IDS_CREATEEVENT,MB_OK);
		goto ChiEnd;
	}
	// Create the window to display the chi data in.
	//..............................................
	GetClientRect(hMainWindow,&rect);

	// Create the window for viewing chi data.
	//........................................
	hViewWindow = CreateWindowEx(WS_EX_CLIENTEDGE,lpszPhiTest,
								 lpszChiTitle,WS_CAPTION | WS_CHILD |
								 WS_SYSMENU | WS_HSCROLL | WS_VSCROLL | 
								 WS_VISIBLE | WS_CLIPCHILDREN,rect.left,
								 rect.top+37,rect.right,rect.bottom-59,
								 hMainWindow,NULL,hInst,NULL);
	if (!hViewWindow)
	{
		ErrorProcedure(lpszNA,IDS_CREATEWINEX,MB_OK);
		goto ChiEnd;;
	}
	SetFocus(hViewWindow);

	// Open the event object.
	//.......................
	hPhiChiOpen = OpenEvent(SYNCHRONIZE,FALSE,TEXT("PhiChiEvent"));
	if (!hPhiChiOpen)
	{
		DestroyWindow(hViewWindow);
		goto ChiEnd;
	}
	// We have to wait for the Edit Event to become signaled 
	// before we can return.
	//......................................................
	while(TRUE)
	{
		if (WaitForSingleObject(hPhiChiEvent,0) == WAIT_OBJECT_0)
		{
			break;
		}
		EmptyTheMessageQue();
	}
	
	ChiEnd:

	FlashMyIcon(FALSE);

	if (hPhiChiOpen)
	{
		CloseHandle(hPhiChiOpen);
		hPhiChiOpen = 0;
	}
	if (hPhiChiEvent)
	{
		CloseHandle(hPhiChiEvent);
		hPhiChiEvent = 0;
	}
	if (hDialogModeLess)
	{
		DestroyWindow(hDialogModeLess);
	}
	if (hChiFile1)
	{
		CloseMyHandle((LPTSTR)&szChiFile1,hChiFile1);
	}
	if (hChiFile2)
	{
		CloseMyHandle((LPTSTR)&szChiFile2,hChiFile2);
	}
	if (lpChiBuffer)
	{
		ZeroMemory(lpChiBuffer,PHI_CHI_BUFFER_SIZE);
		DeallocateMemory(lpChiBuffer);
	}
	if (lpTableChi1)
	{
		ZeroMemory(lpTableChi1,TABLE_SIZE);
		DeallocateMemory(lpTableChi1);
		lpTableChi1 = 0;
	}
	if (lpTableChi2)
	{
		ZeroMemory(lpTableChi2,TABLE_SIZE);
		DeallocateMemory(lpTableChi2);
		lpTableChi2 = 0;
	}
	bCancelOperation = FALSE;
	ChangeHelpTopic(dwOldHelpNumber);
	bProcessInProgress = FALSE;
}

// CALLBACK procedure for accumulating chi data.
//..............................................
LRESULT CALLBACK GetChiDataProc(HWND hDlg, UINT uiMsg, WPARAM wParam, 
								LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			// Setup the names of the encrypted files.
			//........................................
			SetDlgItemTextFmt(hDlg,IDC_FILE1,
						     (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szChiFile1));
			SetDlgItemTextFmt(hDlg,IDC_FILE2,
							 (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szChiFile2));

			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDCANCEL));
			return(FALSE);
		}

		case WM_ACTIVATE:
		{
			if (wParam == 0)
			{
				hDlgCurrent = NULL;
			}
			else
			{
				hDlgCurrent = hDlg;
			}
			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				// Inform the procedure that we want to quit.
				//...........................................
				case IDCANCEL:
				{
					bCancelOperation = TRUE;
				}
				break;
			}
		}
		break;

		case WM_DESTROY:
		{
			hDialogModeLess = NULL;
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Setup the Chi View Window for displaying the Chi data.
//.......................................................
VOID SetupChiViewWindow()
{
	TCHAR		szOutBuffer[80];
	TCHAR		szInBuffer[80];

	// Fill the rectangle with a white background.
	//............................................
	FillRect(hCompatDC,&BitMapRect,(HBRUSH)(COLOR_WINDOW+1));
	SelectObject(hCompatDC,GetStockObject(NULL_BRUSH));
	SetBkColor(hCompatDC,GetSysColor(COLOR_WINDOW));

	iTotalLines = 1;
	
	// Print the file name.
	//.....................
	SetTextColor(hCompatDC,RGB(0,128,0));
	TextOut(hCompatDC,Col(1),Line(iTotalLines),lpszName1,lstrlen(lpszName1));
	iTotalLines++;
	SetTextColor(hCompatDC,RGB(210,0,0));
	if (lstrlen(lpChiFileName1) > 78)
	{
		TextOut(hCompatDC,Col(1),Line(iTotalLines),lpChiFileName1,78);
	}
	else
	{
		TextOut(hCompatDC,Col(1),Line(iTotalLines),lpChiFileName1,lstrlen(lpChiFileName1));
	}
	iTotalLines += 2;

	// Print the second file name.
	//............................
	SetTextColor(hCompatDC,RGB(0,128,0));
	TextOut(hCompatDC,Col(1),Line(iTotalLines),lpszName2,lstrlen(lpszName2));
	iTotalLines++;
	SetTextColor(hCompatDC,RGB(210,0,0));
	if (lstrlen(lpChiFileName2) > 78)
	{
		TextOut(hCompatDC,Col(1),Line(iTotalLines),lpChiFileName2,78);
	}
	else
	{
		TextOut(hCompatDC,Col(1),Line(iTotalLines),lpChiFileName2,lstrlen(lpChiFileName2));
	}
	iTotalLines += 2;

	// Setup to display 6 digits after the decimal point.
	//...................................................
	nFormatInfo.NumDigits = 6;

	// Print the two chi data sizes.
	//..............................
	SetTextColor(hCompatDC,RGB(0,128,0));
	TextOut(hCompatDC,Col(1),Line(iTotalLines),lpszChiData1,lstrlen(lpszChiData1));

	_ui64toa(liChiFileSize1.QuadPart,(LPBYTE)&szInBuffer,10);
	GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szInBuffer,
				    &nFormatInfo,(LPTSTR)&szOutBuffer,sizeof(szOutBuffer));
	SetTextColor(hCompatDC,RGB(0,0,255));
	TextOut(hCompatDC,Col((73 - lstrlen(szOutBuffer))),Line(iTotalLines),
			szOutBuffer,lstrlen(szOutBuffer));
	iTotalLines += 2;

	SetTextColor(hCompatDC,RGB(0,128,0));
	TextOut(hCompatDC,Col(1),Line(iTotalLines),lpszChiData2,lstrlen(lpszChiData2));

	_ui64toa(liChiFileSize2.QuadPart,(LPBYTE)&szInBuffer,10);
	GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szInBuffer,
				    &nFormatInfo,(LPTSTR)&szOutBuffer,sizeof(szOutBuffer));
	SetTextColor(hCompatDC,RGB(0,0,255));
	TextOut(hCompatDC,Col((73 - lstrlen(szOutBuffer))),Line(iTotalLines),
			szOutBuffer,lstrlen(szOutBuffer));
	iTotalLines += 2;

	// Do the expected chi value.
	//...........................
	SetTextColor(hCompatDC,RGB(0,128,0));
	TextOut(hCompatDC,Col(1),Line(iTotalLines),lpszExpChi,lstrlen(lpszExpChi));

	_ui64toa(uliExpectedChi.QuadPart,(LPBYTE)&szInBuffer,10);
	GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szInBuffer,
				    &nFormatInfo,(LPTSTR)&szOutBuffer,sizeof(szOutBuffer));
	SetTextColor(hCompatDC,RGB(0,0,255));
	TextOut(hCompatDC,Col((73 - lstrlen(szOutBuffer))),Line(iTotalLines),
			szOutBuffer,lstrlen(szOutBuffer));
	iTotalLines += 2;

	// Do the observed chi value.
	//...........................
	SetTextColor(hCompatDC,RGB(0,128,0));
	TextOut(hCompatDC,Col(1),Line(iTotalLines),lpszObsChi,lstrlen(lpszObsChi));

	_ui64toa(uliObservedChi.QuadPart,(LPBYTE)&szInBuffer,10);
	GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szInBuffer,
				    &nFormatInfo,(LPTSTR)&szOutBuffer,sizeof(szOutBuffer));
	SetTextColor(hCompatDC,RGB(0,0,255));
	TextOut(hCompatDC,Col((73 - lstrlen(szOutBuffer))),Line(iTotalLines),
			szOutBuffer,lstrlen(szOutBuffer));
	iTotalLines += 2;

	// Reset the number of digits after the decimal point.
	//....................................................
	nFormatInfo.NumDigits = 0;
}

// Setup the Phi View Window for displaying the Phi data.
//.......................................................
VOID SetupPhiViewWindow()
{
	DWORD		dwGroups;
	DWORD		dwLineGroup;
	DWORD		dwLeftIndex;
	DWORD		dwRightIndex;
	DWORD		dwLeftCount;
	DWORD		dwRightCount;
	DOUBLE		fpLeftCount;
	DOUBLE		fpRightCount;
	DOUBLE		fpLeftPercent;
	DOUBLE		fpRightPercent;
	DOUBLE		fpFileSize;
	TCHAR		szOutBuffer[80];
	TCHAR		szInBuffer[80];
	TCHAR		szNumberBuffer[30];

	// Fill the rectangle with a white background.
	//............................................
	FillRect(hCompatDC,&BitMapRect,(HBRUSH)(COLOR_WINDOW+1));
	SelectObject(hCompatDC,GetStockObject(NULL_BRUSH));
	SetBkColor(hCompatDC,GetSysColor(COLOR_WINDOW));

	iTotalLines = 1;
	
	// Print the file name.
	//.....................
	SetTextColor(hCompatDC,RGB(0,128,0));
	TextOut(hCompatDC,Col(1),Line(iTotalLines),lpszName,lstrlen(lpszName));
	iTotalLines++;
	SetTextColor(hCompatDC,RGB(210,0,0));
	if (lstrlen(lpPhiFileName) > 78)
	{
		TextOut(hCompatDC,Col(1),Line(iTotalLines),lpPhiFileName,78);
	}
	else
	{
		TextOut(hCompatDC,Col(1),Line(iTotalLines),lpPhiFileName,lstrlen(lpPhiFileName));
	}
	iTotalLines += 2;

	// Setup to display 6 digits after the decimal point.
	//...................................................
	nFormatInfo.NumDigits = 6;

	// Print the phi data size.
	//.........................
	SetTextColor(hCompatDC,RGB(0,128,0));
	TextOut(hCompatDC,Col(1),Line(iTotalLines),lpszPhiData,lstrlen(lpszPhiData));

	_ui64toa(liFileSize.QuadPart,(LPBYTE)&szInBuffer,10);
	GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szInBuffer,
				    &nFormatInfo,(LPTSTR)&szOutBuffer,sizeof(szOutBuffer));
	SetTextColor(hCompatDC,RGB(0,0,255));
	TextOut(hCompatDC,Col((73 - lstrlen(szOutBuffer))),Line(iTotalLines),
			szOutBuffer,lstrlen(szOutBuffer));
	iTotalLines += 2;

	// Do the expected phi value.
	//...........................
	SetTextColor(hCompatDC,RGB(0,128,0));
	TextOut(hCompatDC,Col(1),Line(iTotalLines),lpszExpPhi,lstrlen(lpszExpPhi));

	_ui64toa(uliExpectedPhi.QuadPart,(LPBYTE)&szInBuffer,10);
	GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szInBuffer,
				    &nFormatInfo,(LPTSTR)&szOutBuffer,sizeof(szOutBuffer));
	SetTextColor(hCompatDC,RGB(0,0,255));
	TextOut(hCompatDC,Col((73 - lstrlen(szOutBuffer))),Line(iTotalLines),
			szOutBuffer,lstrlen(szOutBuffer));
	iTotalLines += 2;

	// Do the observed phi value.
	//...........................
	SetTextColor(hCompatDC,RGB(0,128,0));
	TextOut(hCompatDC,Col(1),Line(iTotalLines),lpszObsPhi,lstrlen(lpszObsPhi));

	_ui64toa(uliObservedPhi.QuadPart,(LPBYTE)&szInBuffer,10);
	GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szInBuffer,
				    &nFormatInfo,(LPTSTR)&szOutBuffer,sizeof(szOutBuffer));
	SetTextColor(hCompatDC,RGB(0,0,255));
	TextOut(hCompatDC,Col((73 - lstrlen(szOutBuffer))),Line(iTotalLines),
			szOutBuffer,lstrlen(szOutBuffer));
	iTotalLines += 2;

	// Do the mean value.
	//...................
	SetTextColor(hCompatDC,RGB(0,128,0));
	TextOut(hCompatDC,Col(1),Line(iTotalLines),lpszMeanValue,lstrlen(lpszMeanValue));

	SetTextColor(hCompatDC,RGB(0,0,255));
	StringCbPrintf(szNumberBuffer,sizeof(szNumberBuffer),TEXT("%f"),fpMeanValue);
	GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szNumberBuffer,
				    &nFormatInfo,(LPTSTR)&szOutBuffer,sizeof(szOutBuffer));
	TextOut(hCompatDC,Col((73 - lstrlen(szOutBuffer))),
			Line(iTotalLines),szOutBuffer,lstrlen(szOutBuffer));
	iTotalLines += 2;

	// Do the variance.
	//.................
	SetTextColor(hCompatDC,RGB(0,128,0));
	TextOut(hCompatDC,Col(1),Line(iTotalLines),lpszVariance,lstrlen(lpszVariance));

	SetTextColor(hCompatDC,RGB(0,0,255));
	StringCbPrintf(szNumberBuffer,sizeof(szNumberBuffer),TEXT("%f"),fpVariance);
	GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szNumberBuffer,
				    &nFormatInfo,(LPTSTR)&szOutBuffer,sizeof(szOutBuffer));
	TextOut(hCompatDC,Col((73 - lstrlen(szOutBuffer))),
			Line(iTotalLines),szOutBuffer,lstrlen(szOutBuffer));
	iTotalLines += 2;

	// Do the standard deviation.
	//...........................
	SetTextColor(hCompatDC,RGB(0,128,0));
	TextOut(hCompatDC,Col(1),Line(iTotalLines),lpszStdDeviation,lstrlen(lpszStdDeviation));

	SetTextColor(hCompatDC,RGB(0,0,255));
	StringCbPrintf(szNumberBuffer,sizeof(szNumberBuffer),TEXT("%f"),fpStandardDeviation);
	GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szNumberBuffer,
				    &nFormatInfo,(LPTSTR)&szOutBuffer,sizeof(szOutBuffer));
	TextOut(hCompatDC,Col((73 - lstrlen(szOutBuffer))),
			Line(iTotalLines),szOutBuffer,lstrlen(szOutBuffer));
	iTotalLines += 2;

	SetTextColor(hCompatDC,RGB(0,0,0));
	TextOut(hCompatDC,Col(24),Line(iTotalLines),lpszFreqTable,lstrlen(lpszFreqTable));
	iTotalLines += 2;

	// Setup to print the 16 groups of character data.
	//................................................
	dwGroups = 16;
	dwLeftIndex = 0;
	dwRightIndex = 8;
	fpFileSize = liFileSize.LowPart;

	while(dwGroups != 0)
	{
		// Print the header line for the individual character stats.
		//..........................................................
		SetTextColor(hCompatDC,RGB(0,128,0));
		TextOut(hCompatDC,Col(2),Line(iTotalLines),lpszHeader,lstrlen(lpszHeader));
		iTotalLines++;
		ZeroMemory(szOutBuffer,sizeof(szOutBuffer));
		FillMemory(szOutBuffer,70,0xaf);
		TextOut(hCompatDC,Col(2),Line(iTotalLines),szOutBuffer,lstrlen(szOutBuffer));
		iTotalLines++;

		SetTextColor(hCompatDC,RGB(0,0,255));

		// Print the 8 lines under this header.
		//.....................................
		dwLineGroup = 8;
		while(dwLineGroup != 0)
		{
			if (dwLeftIndex == 0)
			{
				StringCbPrintf(szOutBuffer,sizeof(szOutBuffer),TEXT("%u  %.2X   %c"),
							   dwLeftIndex,dwLeftIndex,1);
			}
			else
			{
				StringCbPrintf(szOutBuffer,sizeof(szOutBuffer),TEXT("%u  %.2X   %c"),
							   dwLeftIndex,dwLeftIndex,dwLeftIndex);
			}

			TextOut(hCompatDC,Col((13 - lstrlen(szOutBuffer))),
					Line(iTotalLines),szOutBuffer,lstrlen(szOutBuffer));
			StringCbPrintf(szOutBuffer,sizeof(szOutBuffer),TEXT("%u  %.2X   %c"),
						   dwRightIndex,dwRightIndex,dwRightIndex);
			TextOut(hCompatDC,Col((50 - lstrlen(szOutBuffer))),
					Line(iTotalLines),szOutBuffer,lstrlen(szOutBuffer));

			// Lets get the counts and calculate the percents.
			//................................................
			__asm
			{
				mov		edi,lpPhiTable
				mov		esi,dwLeftIndex
				mov		eax,dword ptr [edi][esi*4]
				mov		dwLeftCount,eax
				mov		esi,dwRightIndex
				mov		eax,dword ptr [edi][esi*4]
				mov		dwRightCount,eax
			}
			fpLeftCount = dwLeftCount;
			fpRightCount = dwRightCount;

			// Set the number of digits after the point to 0.
			//...............................................
			nFormatInfo.NumDigits = 0;

			// Do the counts.
			//...............
			StringCbPrintf(szNumberBuffer,sizeof(szNumberBuffer),TEXT("%f"),fpLeftCount);
			GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szNumberBuffer,
							&nFormatInfo,(LPTSTR)&szOutBuffer,sizeof(szOutBuffer));
			TextOut(hCompatDC,Col((27 - lstrlen(szOutBuffer))),
				    Line(iTotalLines),szOutBuffer,lstrlen(szOutBuffer));

			StringCbPrintf(szNumberBuffer,sizeof(szNumberBuffer),TEXT("%f"),fpRightCount);
			GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szNumberBuffer,
							&nFormatInfo,(LPTSTR)&szOutBuffer,sizeof(szOutBuffer));
			TextOut(hCompatDC,Col((64 - lstrlen(szOutBuffer))),
				    Line(iTotalLines),szOutBuffer,lstrlen(szOutBuffer));

			// Set the number of digits after the point to 4.
			//...............................................
			nFormatInfo.NumDigits = 4;

			// Now do the percentages.
			//........................
			fpLeftPercent = (fpLeftCount * 100) / fpFileSize;
			fpRightPercent = (fpRightCount * 100) /fpFileSize;

			StringCbPrintf(szNumberBuffer,sizeof(szNumberBuffer),TEXT("%f"),fpLeftPercent);
			GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szNumberBuffer,
							&nFormatInfo,(LPTSTR)&szOutBuffer,sizeof(szOutBuffer));
			TextOut(hCompatDC,Col((35 - lstrlen(szOutBuffer))),
					Line(iTotalLines),szOutBuffer,lstrlen(szOutBuffer));

			StringCbPrintf(szNumberBuffer,sizeof(szNumberBuffer),TEXT("%f"),fpRightPercent);
			GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szNumberBuffer,
							&nFormatInfo,(LPTSTR)&szOutBuffer,sizeof(szOutBuffer));
			TextOut(hCompatDC,Col((72 - lstrlen(szOutBuffer))),
					Line(iTotalLines),szOutBuffer,lstrlen(szOutBuffer));

			iTotalLines++;
			dwLeftIndex++;
			dwRightIndex++;
			dwLineGroup--;
		}
		iTotalLines++;
		dwLeftIndex += 8;
		dwRightIndex += 8;
		dwGroups--;
	}
	// Reset the digits after the decimal point to 0.
	//...............................................
	nFormatInfo.NumDigits = 0;
}

// Register the window class to use for viewing Phi data on
// encrypted files.
//.........................................................
BOOL RegisterPhiWindow()
{
	WNDCLASS	wc;

	wc.style		 = CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
	wc.lpfnWndProc	 = (WNDPROC)PhiProc;
	wc.cbClsExtra	 = 0;
	wc.cbWndExtra	 = 0;
	wc.hInstance	 = hInst;
	wc.hIcon		 = LoadIcon(hInst,lpEncFileIcon);
	wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
    wc.lpszMenuName  = NULL;              
    wc.lpszClassName = lpszPhiTest;
	
	if (bIsWin9x)
	{
		if (!RegisterWin95(&wc))
		{
			return(FALSE);
		}
	}
	else if (!RegisterClass(&wc))
	{
		return(FALSE);
	}
	return(TRUE);
}

// Window procedure for processing message for Phi Test.
//......................................................
LRESULT CALLBACK PhiProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
		case WM_CREATE:
		{
			HMENU			hViewWinMenu;
			MENUITEMINFO	mii;
			
			ShowScrollBar(hWnd,SB_BOTH,TRUE);

			// Disable the move menu item on the window menu.
			//...............................................
			hViewWinMenu = GetSystemMenu(hWnd,FALSE);

			ZeroMemory(&mii,sizeof(MENUITEMINFO));
			mii.cbSize = sizeof(MENUITEMINFO);
			mii.fMask = MIIM_ID | MIIM_STATE;
			mii.fState = MFS_GRAYED;
			mii.wID = -10;
			SetMenuItemInfo(hViewWinMenu,SC_MOVE,FALSE,&mii);

			// Setup the default DC for our window.
			//.....................................
			hDC = GetDC(hWnd);
			if (!hDC)
			{
				goto ErrorCreate;
			}
			// Create a compatable DC and bitmap to hold at least 
			// 193 lines of text.
			//...................................................
			hCompatDC = CreateCompatibleDC(hDC);
			if (!hCompatDC)
			{
			  ErrorCreate:

				if (hCompatDC)
				{
					DeleteDC(hCompatDC);
					hCompatDC = 0;
				}
				if (hbm)
				{
					DeleteObject(hbm);
					hbm = 0;
				}
				return(-1);
			}
			// Setup our fixed pitch font to use.
			//...................................
			SelectObject(hCompatDC,GetStockObject(ANSI_FIXED_FONT));
			GetTextMetrics(hCompatDC,&tm);
			yChar = tm.tmHeight + tm.tmExternalLeading;
			xChar = tm.tmMaxCharWidth;

			RtMargin = 0;

			if (!cfg.dwLeftAlign)
			{
				// Get centering information for the window.
				//..........................................
				iMaxWidth = GetSystemMetrics(SM_CXMAXIMIZED);

				RtMargin = (((iMaxWidth / xChar) - 77) / 2) - 1;

				if (RtMargin < 0)
				{
					RtMargin = 0;
				}
			}
			// Arbitary max width of client area.
			//...................................
			xClientMax = ((77 + RtMargin) * xChar);

			// Set the mapping mode.
			//......................
			SetMapMode(hCompatDC,MM_TEXT);

			// Setup a rect for the bitmap.
			//.............................
			BitMapRect.left = 0;
			BitMapRect.top = 0;
			BitMapRect.right = xClientMax;

			if (bPhiTest)
			{
				BitMapRect.bottom = 195 * yChar;
			}
			else
			{
				BitMapRect.bottom = 17 * yChar;
			}
			hbm = CreateCompatibleBitmap(hDC,BitMapRect.right,BitMapRect.bottom);
			if (!hbm)
			{
				goto ErrorCreate;
			}
			// Select the bitmap into the compatible DC.
			//..........................................
			SelectObject(hCompatDC,hbm);

			// Setup the phi view window.
			//...........................
			if (bPhiTest)
			{
				SetupPhiViewWindow();
			}
			else
			{
				SetupChiViewWindow();
			}
			bViewWindowDisplayed = TRUE;
		}
		break;

		case WM_SYSCOLORCHANGE:
		{
			if (bPhiTest)
			{
				SetupPhiViewWindow();
			}
			else
			{
				SetupChiViewWindow();
			}
			bScrollWnd = TRUE;
			InvalidateRect(hWnd,NULL,FALSE);
		}
		break;

		case WM_PAINT:
		{
			PRECT	prect;
			BOOL	bHaveUpdate;

			bHaveUpdate = GetUpdateRect(hWnd,NULL,FALSE);

			BeginPaint(hWnd,&ps);

			// Draw the lines of text from the bitmap.
			//........................................
			if (bSizeWnd)
			{
				BitBlt(hDC,ps.rcPaint.left,ps.rcPaint.top,xClient,yClient,
					   hCompatDC,xPos * xInc,yPos * yInc,SRCCOPY);
			}
			if (bScrollWnd)
			{
				prect = &ps.rcPaint;

				BitBlt(ps.hdc,prect->left,prect->top,
					   prect->right - prect->left,
					   prect->bottom - prect->top,
					   hCompatDC,prect->left + (xPos * xChar),
					   prect->top + (yPos * yChar),SRCCOPY);
			}
			if (!bScrollWnd && !bSizeWnd && bHaveUpdate)
			{
				prect = &ps.rcPaint;

				BitBlt(ps.hdc,prect->left,prect->top,
					   prect->right - prect->left,
					   prect->bottom - prect->top,
					   hCompatDC,prect->left + (xPos * xChar),
					   prect->top + (yPos * yChar),SRCCOPY);
			}
			bSizeWnd = FALSE;
			bScrollWnd = FALSE;
			EndPaint(hWnd,&ps);
		}
		break;

		case WM_SIZE:
		{
			// Retrieve the dminension of the client area.
			//............................................
			yClient = HIWORD(lParam);
			xClient = LOWORD(lParam);

			xPos = 0;
			yPos = 0;

			// Determine the maximum vertical scrolling position.
			// The two is added for extra space below the lines
			// of text and the status bar.
			//...................................................
			yMax = max(0,iTotalLines + 2 - (yClient/yChar));

			// Make sure the current vertical scrolling position
			// does not exceed the maximum.
			//..................................................
			yPos = min(yPos,yMax);

			if ((yClient/yChar) < iTotalLines)
			{
				sci.cbSize = sizeof(SCROLLINFO);
				sci.fMask = SIF_POS | SIF_RANGE | SIF_PAGE;
				sci.nMin = 0;
				sci.nMax = iTotalLines - 1;
				sci.nPage = (yClient/yChar) + 1;
				sci.nPos = yPos;

				EnableScrollBar(hWnd,SB_VERT,ESB_ENABLE_BOTH);
				SetScrollInfo(hWnd,SB_VERT,&sci,TRUE);
			}
			else
			{
				EnableScrollBar(hWnd,SB_VERT,ESB_DISABLE_BOTH);
			}
			// Determine the maximum horizontal scrolling position.
			//.....................................................
			xMax = max(0,((xClientMax - xClient)/xChar));

			// Make sure the current horizontal scrolling position
			// does not exceed the maximum.
			//....................................................
			xPos = min(xPos,xMax);
			
			if (xMax < (77 + RtMargin))
			{
				sci.cbSize = sizeof(SCROLLINFO);
				sci.fMask = SIF_POS | SIF_RANGE | SIF_PAGE;
				sci.nMin = 0;
				sci.nMax = 77 + RtMargin - 1;
				sci.nPage = (xClient / xChar) + 1;
				sci.nPos = xPos;

				EnableScrollBar(hWnd,SB_HORZ,ESB_ENABLE_BOTH);
				SetScrollInfo(hWnd,SB_HORZ,&sci,TRUE);
			}
			else
			{
				EnableScrollBar(hWnd,SB_HORZ,ESB_DISABLE_BOTH);
			}
			// Redisplay the phi or chi data.
			//...............................
			bSizeWnd = TRUE;
			InvalidateRect(hWnd,NULL,FALSE);
		}
		break;

		case WM_CLOSE:
		{
			DestroyWindow(hWnd);
		}
		break;

		case WM_DESTROY:
		{
			if (hCompatDC)
			{
				DeleteDC(hCompatDC);
				hCompatDC = 0;
			}
			if (hbm)
			{
				DeleteObject(hbm);
				hbm = 0;
			}
			// Notify the view tsc encrypted file procedure it
			// can continue.
			//................................................
			SetEvent(hPhiChiEvent);

			bViewWindowDisplayed = FALSE;
		}
		break;

		case WM_HSCROLL:
		{
			switch (LOWORD(wParam))
			{
				// We clicked the shaft left of the scroll box.
				//.............................................
				case SB_PAGELEFT:
				{
					xInc = -8;
					break;
				}
				// We clicked the shaft right of the scroll box.
				//..............................................
				case SB_PAGERIGHT:
				{
					xInc = 8;
					break;
				}
				// We clicked the left arrow.
				//...........................
				case SB_LINELEFT:
				{
					xInc = -1;
					break;
				}
				// We clicked the right arrow.
				//............................
				case SB_LINERIGHT:
				{
					xInc = 1;
					break;
				}
				// We dragged the scroll bar.
				//...........................
				case SB_THUMBTRACK:
				{
					xInc = HIWORD(wParam) - xPos;
					break;
				}
				default:
					xInc = 0;
			}
			// If applying the horizontal scrolling increment does not
			// take the scrolling position out of the scrolling range,
			// increment the scrolling position, adjust the position
			// of the scroll box, and update the window.
			//........................................................
			if (xInc = max(-xPos, min(xInc, xMax-xPos)))
			{
				bScrollWnd = TRUE;
				xPos += xInc;
				ScrollWindowEx(hWnd,-xChar * xInc,0,NULL,NULL,
							   NULL,NULL,SW_INVALIDATE | SW_ERASE);
				sci.cbSize = sizeof(SCROLLINFO);
				sci.fMask = SIF_POS;
				sci.nPos = xPos;
				SetScrollInfo(hWnd,SB_HORZ,&sci,TRUE);
				UpdateWindow(hWnd);
			}
			break;
		}

		case WM_MOUSEWHEEL:
		{
			int			iIncrements;

			if (uiWheelScrollLines != 0)
			{
				// Default value.
				//...............
				yInc = 0;

				if (wParam & (MK_SHIFT | MK_CONTROL))
				{	
					return(DefWindowProc(hWnd,uMsg,wParam,lParam));
				}
				iDelta -= (SHORT) HIWORD(wParam);
				iIncrements = iDelta / WHEEL_DELTA;
				iDelta %= WHEEL_DELTA;

				if (iIncrements != 0)
				{
					if (uiWheelScrollLines == WHEEL_PAGESCROLL)
					{
						if (iIncrements < 0)
						{
							// PageUp.
							//.......
							yInc = min(-1,-yClient / yChar);
						}
						else
						{
							yInc = max(1,yClient / yChar);
						}
					}
					else
					{
						yInc = iIncrements * uiWheelScrollLines;
					}
				}
				// If applying the vertical scrolling increment does not
				// take the scrolling position out of the scrolling range,
				// increment the scrolling position, adjust the position
				// of the scroll box, and update the window.
				//.......................................................
				if (yInc = max(-yPos, min(yInc, yMax - yPos)))
				{
					bScrollWnd = TRUE;
	
					yPos += yInc;
				
					// Only scroll the window if yInc is less than yClient.
					// If greater or equal to yClient invalidate the whole
					// rectangle and redraw it.
					//....................................................
					if (abs(yInc) < yClient)
					{
						ScrollWindowEx(hWnd,0,-yChar * yInc,NULL,NULL,
									   NULL,NULL,SW_INVALIDATE | SW_ERASE);
					}
					else
					{
						InvalidateRect(hWnd,NULL,TRUE);
					}

					sci.cbSize = sizeof(SCROLLINFO);
					sci.fMask = SIF_POS;
					sci.nPos = yPos;
					SetScrollInfo(hWnd,SB_VERT,&sci,TRUE);
					UpdateWindow(hWnd);
				}
			}
		}
		break;
	
		case WM_VSCROLL:
		{
			switch(LOWORD(wParam))
			{
				// We clicked the shaft above the scroll box.
				//...........................................
				case SB_PAGEUP:
				{
					yInc = min(-1,-yClient / yChar);
					break;
				}
				// We clicked the shaft below the scroll box.
				//...........................................
				case SB_PAGEDOWN:
				{
					yInc = max(1,yClient / yChar);
					break;
				}
				// We clicked the top arrow.
				//..........................
				case SB_LINEUP:
				{
					yInc = -1;
					break;
				}
				// We clicked the bottom arrow.
				//.............................
				case SB_LINEDOWN:
				{
					yInc = 1;
					break;
				}
				// We dragged the scroll box.
				//...........................
				case SB_THUMBTRACK:
				{
					yInc = HIWORD(wParam) - yPos;
					break;
				}
				// We used the home key to go to the top.
				//.......................................
				case SB_TOP:
				{
					yInc = -yMax;
					break;
				}
				// We used the end key to go to the bottom.
				//.........................................
				case SB_BOTTOM:
				{
					yInc = yMax;
					break;
				}

				default:
					yInc = 0;
			}
			// If applying the vertical scrolling increment does not
			// take the scrolling position out of the scrolling range,
			// increment the scrolling position, adjust the position
			// of the scroll box, and update the window.
			//.......................................................
			if (yInc = max(-yPos, min(yInc, yMax - yPos)))
			{
				bScrollWnd = TRUE;

				yPos += yInc;
				
				// Only scroll the window if yInc is less than yClient.
				// If greater or equal to yClient invalidate the whole
				// rectangle and redraw it.
				//....................................................
				if (abs(yInc) < yClient)
				{
					ScrollWindowEx(hWnd,0,-yChar * yInc,NULL,NULL,
								   NULL,NULL,SW_INVALIDATE | SW_ERASE);
				}
				else
				{
					InvalidateRect(hWnd,NULL,TRUE);
				}

				sci.cbSize = sizeof(SCROLLINFO);
				sci.fMask = SIF_POS;
				sci.nPos = yPos;
				SetScrollInfo(hWnd,SB_VERT,&sci,TRUE);
				UpdateWindow(hWnd);
			}
			break;
		}
		// Capture the keyboard keys for manipulating the scroll bars.
		//............................................................
		case WM_KEYDOWN:
		{
			WORD	wScrollAction = 0xFFFF;
			UINT	ScrollMsg = WM_VSCROLL;

			switch(wParam)
			{
				case VK_UP:
				{
					wScrollAction = SB_LINEUP;
					break;
				}
				case VK_DOWN:
				{
					wScrollAction = SB_LINEDOWN;
					break;
				}
				case VK_PRIOR:
				{
					wScrollAction = SB_PAGEUP;
					break;
				}
				case VK_NEXT:
				{
					wScrollAction = SB_PAGEDOWN;
					break;
				}
				case VK_HOME:
				{
					wScrollAction = SB_TOP;
					break;
				}
				case VK_END:
				{
					wScrollAction = SB_BOTTOM;
					break;
				}
				// Take care of the horizontal scroll bar.
				//........................................
				case VK_LEFT:
				{
					wScrollAction = SB_LINELEFT;
					ScrollMsg = WM_HSCROLL;
					break;
				}
				case VK_RIGHT:
				{
					wScrollAction = SB_LINERIGHT;
					ScrollMsg = WM_HSCROLL;
					break;
				}
				case VK_ESCAPE:
				{
					DestroyWindow(hWnd);
					break;
				}
			}
			if (wScrollAction != -1)
			{
				SendMessage(hWnd,ScrollMsg,MAKELONG(wScrollAction,0),0L);
			}
			break;
		}		
        default:
			return(DefWindowProc(hWnd, uMsg, wParam, lParam));

	}
	return(0L);
}

// Quad precision multiply procedure.
// Entry: Argument 1 in qa1 and argument 2 in qa2.
// 
// Exit: Quad result in qr1.
//...................................
VOID QuadMultiply()
{
	__asm
	{
		mov		eax,qa1.LOW
		mov		edx,qa1.HIGH
		mov		ebx,qa2.LOW
		mov		ecx,qa2.HIGH
		
		// Save copy of arg1.
		//...................
		mov		edi,edx
		mov		esi,eax
		mul		ebx				// arg1 low * arg2 low
		mov		qr1.ARG0,eax
		mov		qr1.ARG1,edx
		mov		eax,edi
		mul		ecx				// arg1 high * arg2 high
		mov		qr1.ARG2,eax
		mov		qr1.ARG3,edx
		mov		eax,edi
		mul		ebx				// arg1 high * arg2 low
		add		qr1.ARG1,eax
		adc		qr1.ARG2,edx
		adc		qr1.ARG3,0
		mov		eax,esi			// arg1 low * arg2 high
		mul		ecx
		add		qr1.ARG1,eax
		adc		qr1.ARG2,edx
		adc		qr1.ARG3,0
	}
}

// Perform a quad precision division procedure.
// Entry: Dividend in qr1.
//        Divisor in qa1.
//
// Exit:  Quotient in qa1.
//        Remainder in qa2.
//.............................................

#pragma warning(disable : 4731)

VOID QuadDivide()
{
	__asm
	{
		// Save ebp.
		//..........
		push	ebp

		mov		eax,qr1.ARG0
		mov		ebx,qr1.ARG1
		mov		ecx,qr1.ARG2
		mov		edx,qr1.ARG3
		mov		edi,qa1.LOW
		mov		esi,qa1.HIGH

		// 3rd dword of dividend.
		//.......................
		mov		ebp,ecx
		mov		ecx,64
		clc
	L1:	rcl		eax,1
		rcl		ebx,1
		rcl		ebp,1
		rcl		edx,1
		jnc		L3
	L2: sub		ebp,edi			// Subtract divisor from high dividend
		sbb		edx,esi
		stc		
		jmp		L5

	L3:	// If the high part of the dividend is less than the
		// high part of the divisor.
		//..................................................
		cmp		edx,esi
		jae		L4
		clc
		jmp		L5

	L4:	// If the high part of the dividend is greater than the
		// high part of the divisor subtractt the divisor again.
		//......................................................
		jne		L2

		// If the high part of the dividend is equal to the high
		// part of the divisor compare the low parts. If the
		// dividend is greater than or equal to the divisor
		// subtract the divisor again.
		//......................................................
		cmp		ebp,edi
		jae		L2
		clc						// Force carry flag clear
	L5:	dec		ecx
		jnz		L1				// Shift carry flag into quotient.

		// Shift the last bit into the quotient.
		//......................................
		rcl		eax,1
		rcl		ebx,1
		mov		ecx,ebp
		xchg	edx,ebx			// Quotient in edx:eax
		xchg	ecx,ebx			// Remainder in ecx:ebx
		mov		qa1.LOW,eax
		mov		qa1.HIGH,edx
		mov		qa2.LOW,ebx
		mov		qa2.HIGH,ecx
		pop		ebp
	}
}

#pragma warning(default : 4731)

// Do the random bits bin stats.
//..............................
VOID RandomBitsBinStats()
{
	ULARGE_INTEGER		uliCurrentTime;
	ULARGE_INTEGER		uliChangesPerSec;
	TCHAR				szBufferIn[512];
	TCHAR				szFormat[256];
	TCHAR				szChanges[48];
	TCHAR				szChangesPerSec[48];
	DWORD				dwOldHelpTopic;
	DWORD				dwTotalHrs;
	DWORD				dwTotalMins;
	DWORD				dwTotalSecs;

	bProcessInProgress = TRUE;
	dwOldHelpTopic = ChangeHelpTopic(IDH_RBBSTATS);

	uliCurrentTime.QuadPart = GetTimestamp(FALSE);
	uliCurrentTime.QuadPart -= uliStart.QuadPart;

	// Calculate the hours, minutes, and seconds.
	//...........................................
	__asm
	{
		mov		eax,uliCurrentTime.LowPart
		mov		edx,uliCurrentTime.HighPart
		mov		ecx,SECS_PER_HOUR
		div		ecx
		mov		dwTotalHrs,eax
		mov		eax,edx
		xor		edx,edx
		mov		ecx,60
		div		ecx
		mov		dwTotalMins,eax
		mov		dwTotalSecs,edx
	}

	uliChangesPerSec.QuadPart = uliChanges.QuadPart / uliCurrentTime.QuadPart;

	// Format the numbers.
	//....................
	nFormatInfo.NumDigits = 0;
	_ui64toa(uliChanges.QuadPart,(LPBYTE)&szBufferIn,10);
	GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPBYTE)&szBufferIn,&nFormatInfo,
					(LPTSTR)&szChanges,sizeof(szChanges));

	_ui64toa(uliChangesPerSec.QuadPart,(LPBYTE)&szBufferIn,10);
	GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPBYTE)&szBufferIn,&nFormatInfo,
					(LPTSTR)&szChangesPerSec,sizeof(szChangesPerSec));

	LoadString(hInst,IDS_RBBSTATS,(LPTSTR)&szFormat,sizeof(szFormat));
	StringCbPrintf((LPTSTR)&szBufferIn,sizeof(szBufferIn),(LPCTSTR)&szFormat,&szChanges,
					dwTotalHrs,dwTotalMins,dwTotalSecs,&szChangesPerSec);

	MessageBoxProc(hMainWindow,(UINT)TEXT("Random Bits Bin Statistics"),(UINT)&szBufferIn,
				   MB_ICONINFORMATION | MB_OK | MB_HELP,MB_ICONINFORMATION,0);

	ChangeHelpTopic(dwOldHelpTopic);
	bCancelOperation = FALSE;
	bProcessInProgress = FALSE;
}
